import React from 'react';

import styles from './index.module.css';

type Props = {
    title?: React.ReactNode;
    banner?: React.ReactNode;
    renderAdditional?: React.ReactElement;
};

const OrdersListHeaderLayout: React.FC<Props> = ({ title, children, banner, renderAdditional }) => {
    return (
        <div className={styles.wrapper}>
            <div className={styles.top}>
                {title && <h1 className={styles.title}>{title}</h1>}
                {renderAdditional}
                {banner && <h2 className={styles.banner}>{banner}</h2>}
            </div>
            <div className={styles.filter}>{children}</div>
        </div>
    );
};

export default OrdersListHeaderLayout;
