import React, { RefObject } from 'react';

import { classNames } from '@yandex-int/tap-components/helpers';

import useConstants from '@hooks/useConstants';

import styles from './index.module.css';

interface IPageProps {
    className?: string;
    containerRef?: RefObject<HTMLDivElement>;
}

const Page: React.FC<IPageProps> = ({ children, className, containerRef }) => {
    const { isPWA } = useConstants();

    return (
        <main ref={containerRef} className={classNames(className, styles.wrapper, isPWA && styles.page_space)}>
            <div className={styles.page}>{children}</div>
        </main>
    );
};

export default Page;
