import React, { useCallback, useState, useRef, memo } from 'react';

import { cn } from '@bem-react/classname';

import Icon from '@components/Icon';
import { Popup } from '@components/Popup';
import useConstants from '@hooks/useConstants';
import './index.css';

const cnPayPlusPromo = cn('PayPlusPromo');

const PayPlusPromo: React.FC = () => {
    const infoRef = useRef<HTMLImageElement>(null);

    const { payServicesPlusPromo } = useConstants();

    const [infoOpened, setInfoOpened] = useState<boolean>(false);

    const handleInfoClick = useCallback(() => {
        setInfoOpened((prev) => !prev);
    }, [setInfoOpened]);

    if (!payServicesPlusPromo) {
        return null;
    }

    const { label, description } = payServicesPlusPromo;

    return (
        <div className={cnPayPlusPromo()}>
            <span className={cnPayPlusPromo('about')}>{label.text}</span>
            <span className={cnPayPlusPromo('cashback')}>
                <span className={cnPayPlusPromo('gradient')}>{label.plusText}</span>
                {description ? (
                    <React.Fragment>
                        <Popup
                            anchor={infoRef}
                            visible={infoOpened}
                            view="default"
                            direction="bottom"
                            target="anchor"
                            hasTail
                            theme="dark"
                            onClose={handleInfoClick}
                        >
                            <div className={cnPayPlusPromo('plusInfoText')}>
                                {description.text.split('\n').map((line, idx) => (
                                    <React.Fragment key={idx}>
                                        {idx === 0 ? null : <br />}
                                        {idx === 0 ? null : <br />}
                                        <span>{line}</span>
                                    </React.Fragment>
                                ))}
                                <a target="_blank" rel="noopener noreferrer" className={cnPayPlusPromo('plusInfoLink')} href={description.legal.href}>
                                    {description.legal.text}
                                </a>.
                            </div>
                        </Popup>
                        <div ref={infoRef} onClick={handleInfoClick} className={cnPayPlusPromo('plusInfo')}>
                            <Icon
                                name="questionMark"
                                theme="common"
                                size="s16"
                            />
                        </div>
                    </React.Fragment>
                ) : null}
            </span>
        </div>
    );
};

export default memo(PayPlusPromo);
