import i18nFactory from '@i18n';
import * as keyset from '@i18n/PayShortcut.i18n';
import React from 'react';

import { IClassNameProps } from '@bem-react/core/core';

import { formatCurrency } from '@client/helpers/number';
import { Shortcut } from '@yandex-id/components';

const i18n = i18nFactory(keyset);

export const PayShortcut: React.FC<IClassNameProps> = ({ className }) => {
    return (
        <Shortcut
            className={className}
            variant="pay"
            icon="pay"
            size="s"
            href="https://pay.yandex.ru/"
            currency={formatCurrency('RUB')}
            label={i18n('Знакомьтесь')}
            text={i18n('Оплаты с Yandex Pay')}
            target="_blank"
            textBold
        />
    );
};
