import PenaltyCard from './index';

import 'yandex-font/build/browser.css';
import { TemplateFactory } from '../../../../.storybook/helpers/TemplateFactory';

export default {
    title: 'Component/PenaltyCard',
    component: PenaltyCard,
    argTypes: {},
    args: {
        price: 2500,
        currency: 'RUB',
        info: 'СТС 49 49 910311',
        status: 'До 16.02.22',
    },
};

const template = TemplateFactory(PenaltyCard);

export const Default = template({});

export const WithDiscount = template({ originalPrice: 5000 });

export const WithPlus = template({ originalPrice: 5000, plus: 250 });

export const Negative = template({ status: 'Просрочен', negative: true, checkboxEnabled: true });

export const WithCheckbox = template({ checkboxEnabled: true });

export const WithCheckedCheckbox = template({ checkboxEnabled: true, checked: true });
