import i18nFactory from '@i18n';
import * as keyset from '@i18n/PlusShortcut.i18n';
import React from 'react';

import { IClassNameProps } from '@bem-react/core';

import { i18nCommon } from '@client/translations/common';
import { Shortcut } from '@yandex-id/components';
import useConstants from '@hooks/useConstants';

const i18n = i18nFactory(keyset);

export const PlusShortcut: React.FC<IClassNameProps> = ({ className }) => {
    const { authInfo } = useConstants();
    const { hasPlus, plusBalance } = authInfo?.user || {};

    if (plusBalance && plusBalance === -1) {
        return null;
    }

    const balance = Math.floor(plusBalance || 0);
    const utmCampaign = hasPlus ? 'yandexid_plus' : 'yandexid_no_plus';
    const amount = hasPlus ? String(balance) : undefined;
    const text = hasPlus ? i18n('Как копить и тратить') : i18n('Фильмы, музыка и кешбэк баллами');
    const size = hasPlus ? 's' : 'l';
    const title = hasPlus ? i18n('Баллы Плюса') : i18n('Яндекс Плюс');
    const buttonText = !hasPlus ? i18nCommon('connect') : undefined;

    return (
        <Shortcut
            className={className}
            variant='plus'
            size={size}
            href={`https://plus.yandex.ru/?utm_source=yandexid&utm_medium=payment_history&utm_campaign=${utmCampaign}`}
            buttonText={buttonText}
            text={text}
            labelBold={hasPlus}
            textBold={!hasPlus}
            label={title}
            amount={amount}
            amountIcon="plus"
            target="_blank"
            withImage={!hasPlus}
        />
    );
};
