import React from 'react';

import { IClassNameProps } from '@bem-react/core';
import { classNames } from '@yandex-int/tap-components/helpers';

import { useIsIE } from '@hooks/useIsIE';
import { isStrictDefined } from '@src/helpers';

import styles from './index.module.css';

import { formatPlus } from '../../helpers/number';

interface Props extends IClassNameProps {
    value?: number;
    mode?: 'small' | 'medium' | 'large';
    refunded?: boolean;
}

const PlusValue: React.FC<Props> = ({ className, value, mode = 'small', refunded }) => {
    const isIe = useIsIE();

    if (!isStrictDefined(value) || value === null) {
        return null;
    }

    return (
        <div className={classNames(styles.plus, styles[mode], isIe ? styles.ie : undefined, className)}>
            {formatPlus(value, Boolean(refunded), { leadPlus: true })}
        </div>
    );
};

export default PlusValue;
