import { withBemMod } from '@bem-react/core';
import { cnRadioButton } from '@yandex-lego/components/RadioButton';
import './RadioButton_view_lite.css';

export interface IRadioButtonViewDefaultProps {
    /**
     * Внешний вид радиогруппы.
     */
    view?: 'lite';
}

/**
 * Модификатор, отвечающий за внешний вид радиогруппы.
 * @param {IRadioButtonViewDefaultProps} props
 */
export const withViewLite = withBemMod<IRadioButtonViewDefaultProps>(cnRadioButton(), { view: 'lite' });
