import React from 'react';

import { classNames } from '@yandex-int/tap-components/helpers';

import styles from './index.module.css';

export type RatioValue = 1;

type Props = {
    value?: RatioValue;
};

const VALUES: Record<RatioValue, string> = {
    '1': '1',
};

const Ratio: React.FC<Props> = ({ value = 1, children }) => {
    return (
        <div className={classNames(styles.ratio, styles['ratio' + VALUES[value]])}>
            <div className={styles.content}>{children}</div>
        </div>
    );
};

export default Ratio;
