import React, { useCallback, useEffect, useRef, useState } from 'react';

import { classnames } from '@bem-react/classnames';

import useConstants from '@hooks/useConstants';

import styles from './index.module.css';

interface IReceiptsPopup {
    onClose(): void;
    onSuccess(): void;
    visible?: boolean;
}

export const ReceiptsPopup: React.FC<IReceiptsPopup> = ({ onClose, onSuccess, visible }) => {
    const { config: { edadealHosts }, fnsData, env } = useConstants();
    // Так как у ребят из едадила нет настоящего тестинга с тестовыми аккаунтами
    // и они могут тестировать только на RC – меняем их продовый хост на стейдж
    const [iframeUrl, setIframeUrl] = useState(
        env === 'rc'
            ? fnsData?.urls?.desktop?.replace('.edadeal.', '.edastage.')
            : fnsData?.urls?.desktop
    );

    useEffect(() => {
        const urlObject = new URL(iframeUrl || '');

        urlObject.searchParams.append('referer', window.location.href);
        setIframeUrl(urlObject.href);
    }, []);

    const [loaded, setLoaded] = useState(false);
    const iframeRef = useRef<HTMLIFrameElement>(null);

    const onMessage = useCallback((event) => {
        if (!edadealHosts?.includes(event.origin)) {
            return;
        }

        event.data === 'ready' && setLoaded(true);
        event.data === 'close' && onClose();
        event.data === 'boundToFns' && onSuccess();
    }, [onClose, onSuccess, edadealHosts]);

    useEffect(() => {
        if (visible && iframeRef.current) {
            iframeRef.current.contentWindow?.postMessage('open', '*');
        }
    }, [visible]);

    useEffect(() => {
        window.addEventListener('message', onMessage);

        return () => {
            window.removeEventListener('message', onMessage);
        };
    }, []);

    return (
        <div className={classnames(styles.container, (visible && loaded) ? styles.container_visible : undefined)}>
            <iframe ref={iframeRef} width="100%" height="100%" src={iframeUrl} frameBorder="0" referrerPolicy="unsafe-url" />
        </div>
    );
};
