import React from 'react';

import { compose, IClassNameProps } from '@bem-react/core';
import { withSizeXXS, withSizeS, withSizeM, withViewDefault } from '@yandex-lego/components/Spin/touch-phone';
import { Spin as LegoSpin, cnSpin } from '@yandex-lego/components/Spin/touch-phone';

const ComposedLegoSpin = compose(withSizeXXS, withSizeS, withSizeM, withViewDefault)(LegoSpin);

interface Props extends IClassNameProps { size: 'xxs' | 's' | 'm'; progress?: boolean; }

const Spin = ({ className, size, ...rest }: Props) => <ComposedLegoSpin className={cnSpin(null, [className])} size={size as ANY} {...rest} view="default" />;

export { LegoSpin };

export default Spin;
