import React from 'react';

import { classNames } from '@yandex-int/tap-components/helpers';

import { getOrderStatusI18nProps, isShowStatus } from '@client/helpers';
import { i18nCommon } from '@client/translations/common';
import Icon, { Size } from '@components/Icon';

import styles from './index.module.css';

interface Props {
    status?: Client.StatusOrder;
    className?: string;
    classNameText?: string;
    classNameIcon?: string;
    size: Size;
    extended?: boolean;
}

const StatusOrder: React.FC<Props> = ({
    status, className, classNameText, classNameIcon, size, extended,
}) => {
    const statusI18n = React.useMemo(() => {
        const statusKey = getOrderStatusI18nProps(status, extended);

        if (!statusKey) {
            return;
        }

        return i18nCommon(statusKey);
    }, [status, extended]);

    if (!isShowStatus(status)) {
        return null;
    }

    return (
        <div className={classNames(styles.status, className)}>
            <Icon size={size} name={status} className={classNameIcon} />
            <span className={classNames(styles.status__text, classNameText)}>{statusI18n}</span>
        </div>
    );
};

export default StatusOrder;
