import { Stub } from './index';

import 'yandex-font/build/browser.css';
import { TemplateFactory } from '../../../../.storybook/helpers/TemplateFactory';

export default {
    title: 'Component/Stub',
    component: Stub,
    argTypes: {},
    args: {
        serviceName: 'Яндекс.Плюс',
        withBackButton: true,
    },
};

const template = TemplateFactory(Stub);

export const Default = template({});

export const WithServiceUrl = template({
    serviceUrl: 'https://ya.ru',
});

export const WithCallback = template({
    onClick: () => {},
    buttonText: 'Подключить',
});

export const WithCustomTexts = template({
    title: 'Платежей пока не видно',
    description: 'Радуйте себя покупками, получайте баллы Плюса, а мы покажем это в истории платежей',
    withBackButton: false,
});
