import React from 'react';

import { classnames } from '@bem-react/classnames';
import { IClassNameProps } from '@bem-react/core';

import Button from '@components/Button';
import useConstants from '@hooks/useConstants';
import { useServiceName } from '@hooks/useServiceName';

import styles from './Stub.module.css';

export interface IStubProps extends IClassNameProps {
    title?: string;
    alias?: string;
    serviceUrl?: string;
    buttonText?: string;
    description?: string;
    withBackButton?: boolean;
    onClick?(): void;
}

export const Stub = React.memo<IStubProps>(({
    className, title, serviceUrl, buttonText, description, alias, onClick, withBackButton,
}) => {
    const serviceName = useServiceName(alias);
    const { isLite, familyMode } = useConstants();

    const hideButtons = isLite || familyMode;

    return (
        <section
            className={classnames(styles.container, className)}>
            <div className={styles.image} />
            <h3 className={styles.title}>{title || 'Таких платежей пока нет'}</h3>
            <p className={styles.description}>{description || `Похоже, вы ещё не покупали на сервисе ${serviceName}`}</p>
            {!hideButtons && (serviceUrl || onClick) && buttonText && (
                <Button className={styles.button} url={serviceUrl} onClick={onClick} view="action" size="m" width="max" type={serviceUrl ? 'link' : undefined} target="_blank">
                    {buttonText || `Перейти в ${serviceName}`}
                </Button>
            )}
            {!hideButtons && withBackButton && (
                <Button className={styles.back} url="/order-history" size="m" width="max" type="link" view="clear">
                    Показать все платежи
                </Button>
            )}
        </section>
    );
});
