import React, { useCallback } from 'react';

import { i18nCommon } from '@client/translations/common';
import { i18nServices } from '@client/translations/services';
import { RadioButton } from '@components/RadioButton';
import useMetrika from '@hooks/useMetrika';
import useRoutes from '@hooks/useRoutes';

import styles from './index.module.css';
interface ITabsProps {
    value: string;
    onChange: React.ChangeEventHandler<HTMLInputElement>;
}

export const Tabs: React.FC<ITabsProps> = ({ value, onChange }) => {
    const routes = useRoutes();
    const metrika = useMetrika();

    const onChangeCallback = useCallback((event) => {
        onChange(event);

        if (event.target.value === routes.receipts()) {
            metrika.params({ click_tab_receipts: true });
        } else {
            metrika.params({ click_tab_yandex: true });
        }
    }, [onChange, metrika, routes]);

    return (
        <div className={styles.container}>
            <RadioButton
                className={styles.radioButton}
                value={value}
                onChange={onChangeCallback}
                size="l"
                view="lite"
                options={[
                    { value: routes.main(), children: i18nCommon('yandex') },
                    { value: routes.receipts(), children: i18nServices('receipts') },
                ]} />
        </div>
    );
};
