import React from 'react';

import { classnames } from '@bem-react/classnames';
import { IClassNameProps } from '@bem-react/core';

import Image from '@components/Image';

import styles from './index.module.css';

export interface ITagProps extends IClassNameProps {
    onClick(): void;
    active?: boolean;
    iconUrl?: string;
    text: string;
}

export const Tag: React.FC<ITagProps> = ({ onClick, active, iconUrl, text, className }) => {
    return (
        <div
            onClick={onClick}
            className={classnames(styles.container, active ? styles.active : '', className)}
        >
            {iconUrl && (
                <Image
                    cover
                    width={20}
                    height={20}
                    className={styles.logo}
                    src={iconUrl}
                    alt={text}
                    aria-hidden
                />
            )}
            <div className={styles.text}>{text}</div>
        </div>
    );
};
