import React from 'react';

import { compose, composeU, ExtractProps } from '@bem-react/core';
import {
    withSizeS,
    withSizeM,
    withViewDefault,
    withViewMaterial,
} from '@yandex-lego/components/Textinput/touch-phone';
import { Textinput as LegoTextinput } from '@yandex-lego/components/Textinput/touch-phone';

import { withMask } from './_mix/_mask/Input_mix_mask';

const ComposedLegoTextinput = compose(
    composeU(
        withSizeS,
        withSizeM,
    ),
    composeU(
        withViewDefault,
        withViewMaterial,
    ),
    withMask,
)(LegoTextinput);

const Textinput = ({ ...rest }: ExtractProps<typeof ComposedLegoTextinput>) => (
    <ComposedLegoTextinput {...rest} />
);

export { LegoTextinput };

export default Textinput;
