import { IBill } from '@src/types';

export const isExpired = (bill: IBill) => {
    const till = bill.payment_deadline ? Date.parse(bill.payment_deadline) : 0;
    const now = Date.now();

    return (now - till > 0);
};

export const getBillsSum = (bills: IBill[]) => bills.reduce((total, bill) => total + bill.discounted_amount, 0);

export const getFee = (bills: IBill[]) => bills.reduce((total, bill) => total + bill.fee_amount, 0);

export const getPrice = (amount: number) => (amount / 100).toFixed(2);
