const STATUS_I18N_KEY: Record<
    Client.StatusOrder,
    'paymentCreated' | 'paymentByCard' | 'paymentCanceled' | 'paymentRefunded' | 'paymentPartiallyRefunded' | 'paymentAdvance'
> = {
    paid: 'paymentByCard',
    created: 'paymentCreated',
    refunded: 'paymentRefunded',
    cancelled: 'paymentCanceled',
    partiallyRefunded: 'paymentPartiallyRefunded',
    advance: 'paymentAdvance',
};

export const getOrderStatusI18nProps = (status?: Nullable<Client.StatusOrder>, extended?: boolean) => {
    if (!status) return null;

    const key = extended ? status + 'Extended' : status;

    return STATUS_I18N_KEY[key] || STATUS_I18N_KEY[status] || null;
};

export const isRefunded = (status?: Nullable<Client.StatusOrder>): boolean => status === 'refunded';

export const isShowStatus = (status?: Nullable<Client.StatusOrder>): status is 'cancelled' | 'refunded' =>
    Boolean(status) && (status === 'cancelled' || status === 'refunded' || status === 'advance');
