import * as reactRedux from 'react-redux';
import type { Dispatch } from 'redux';

import type { State } from '@src/types';

import type { Action } from '../../redux';

export const useSelector = <Selected = unknown>(
    selector: (state: State) => Selected,
    equalityFn?: (left: Selected, right: Selected) => boolean,
) => reactRedux.useSelector(selector, equalityFn);

export const useDispatch: () => Dispatch<Action> = reactRedux.useDispatch;
