import { useEffect, useRef } from 'react';
import { useHistory } from 'react-router';

import { failPayment, setBillsState, successPayment } from '@client/redux/bills';

import { useDispatch, useSelector } from './redux';
import { useBillsApi } from './useBillsApi';

const PAYMENT_STATUS_POOL_INTERVAL = 5 * 1000;

export const useBillsPaymentPolling = () => {
    const dispatch = useDispatch();
    const history = useHistory();

    const billsPayment = useSelector((state) => state.bills.payment);
    const { getTransaction } = useBillsApi();

    const pollStatusTimer = useRef<NodeJS.Timeout>();

    useEffect(() => {
        const stopPool = () => {
            if (pollStatusTimer.current) {
                clearTimeout(pollStatusTimer.current);
                pollStatusTimer.current = undefined;
            }
        };

        const poolPayment = () => {
            if (billsPayment.transactionId) {
                getTransaction(billsPayment.transactionId).then((data) => {
                    if (data.transaction.status === 'NEW') {
                        pollStatusTimer.current = setTimeout(
                            poolPayment,
                            PAYMENT_STATUS_POOL_INTERVAL,
                        );
                    } else if (data.transaction.status === 'PAID') {
                        dispatch(successPayment());
                        dispatch(setBillsState('outdated'));

                        const { state, ...to } = history.location;

                        history.replace(to);
                    } else {
                        dispatch(failPayment());
                    }
                });
            } else {
                stopPool();
            }
        };

        if (billsPayment.transactionId) {
            poolPayment();
        }

        return stopPool;
    }, [dispatch, getTransaction, billsPayment.transactionId]);
};
