import { useCallback } from 'react';

import { updateBills } from '@client/redux/bills';

import { useDispatch } from './redux';
import { useBillsApi } from './useBillsApi';

export const useBillsRestartSearch = () => {
    const dispatch = useDispatch();
    const billsApi = useBillsApi();

    const restartSearch = useCallback(
        () => {
            billsApi.restartSearch().then(() => {
                dispatch(updateBills({
                    state: 'outdated',
                    list: [],
                }));
            });
        },
        [billsApi, dispatch],
    );

    return restartSearch;
};
