import { createContext } from 'react';

import { Constants } from '@src/types';

export const constantsContext = createContext<Constants>({
    env: 'dev',
    baseUrl: '',
    lang: 'ru',
    tld: 'ru',
    isPWA: false,
    platform: {
        isTouch: false,
        isMobile: false,
        isBrowser: true,
        BrowserName: '',
        OSFamily: '',
    },
    plusServiceData: {
        serviceName: '',
        iconUrl: '',
        splashUrl: '',
    },
    payServicesEnabled: false,
    payServices: [],
    config: {
        passportHost: '',
        avatarHost: '',
        yandexHost: '',
    },
    nonce: '',
    flags: {
        newHelpdesk: false,
        newSecurity: false,
        isYandexoid: false
    },
    yandexPay: {
        scriptSrc: '',
        merchantId: '',
        merchantName: '',
        gateway: '',
        gatewayId: '',
        env: 'TESTING',
    },
    bills: {
        maxSelected: 100,
    },
});

export const ConstantsProvider = constantsContext.Provider;
