import type { Locale } from 'date-fns';
import beLocale from 'date-fns/locale/be';
import enLocale from 'date-fns/locale/en-US';
import kkLocale from 'date-fns/locale/kk';
import ruLocale from 'date-fns/locale/ru';
import { useCallback } from 'react';

import * as dateHelpers from '@client/helpers/date';
import type { DateFNSDate, AutoDateOptions } from '@client/helpers/date';
import useConstants from '@hooks/useConstants';
import type { Constants } from '@src/types';

const LOCALE: Record<Constants['lang'], Locale> = {
    ru: ruLocale,
    en: enLocale,
    kk: kkLocale,
    be: beLocale,
};

const useLocale = () => LOCALE[useConstants().lang];

export const useDateFormatter = () => {
    const locale = useLocale();

    return useCallback((date: DateFNSDate, format: string) => dateHelpers.formatDate(date, format, locale), [locale]);
};

export const useDateAutoFormatter = () => {
    const locale = useLocale();

    return useCallback(
        (date: string, options: AutoDateOptions = {}) => dateHelpers.formatDateAuto(date, options, locale),
        [locale],
    );
};

const useDateFormatters = () => {
    const formatDate = useDateFormatter();
    const formatDateAuto = useDateAutoFormatter();

    return {
        formatDate,
        formatDateAuto,
    };
};

export default useDateFormatters;
