import { useRef, useCallback, useLayoutEffect } from 'react';

// adapted from snippet at:
// https://reactjs.org/docs/hooks-faq.html#how-to-read-an-often-changing-value-from-usecallback
const useEventCallback = <F extends (...args: ANY[]) => ANY>(fn: F): F => {
    const ref = useRef<F>((() => {
        throw new Error('Cannot call an event handler while rendering.');
    }) as ANY);

    useLayoutEffect(() => {
        ref.current = fn;
    }, [fn]);

    return useCallback(((...args: ANY) => ref.current(...args)) as ANY, []);
};

export default useEventCallback;
