import { useEffect, useRef } from 'react';

type VoidFn = () => void;

export const useInterval:(callback: VoidFn, delay: number) => void = (callback, delay) => {
    const savedCallback = useRef<VoidFn>();

    useEffect(() => {
        savedCallback.current = callback;
    }, [callback]);

    useEffect(() => {
        function tick() {
            savedCallback.current?.();
        }
        if (delay !== null) {
            const id = setInterval(tick, delay);

            return () => clearInterval(id);
        }
    }, [delay]);
};
