import { useRef, useEffect } from 'react';
import { useLocation } from 'react-router';

import useConstants from '@hooks/useConstants';

import useMetrika from '.';

const useHit = (page: 'main' | 'order', noData?: boolean) => {
    const metrika = useMetrika();
    const { lang, baseUrl } = useConstants();
    const { hash, search, pathname } = useLocation();
    const pathnameRef = useRef(pathname);
    const url = baseUrl + pathname + search + hash;

    useEffect(() => {
        if (!noData && pathnameRef.current === pathname) {
            metrika.hit(url, {
                lang,
                pageId: `order-history-${page}`,
            });
        }
    }, [url, page, lang, metrika, noData, pathname]);
};

export default useHit;
