import { useMemo } from 'react';

import { getPasssportAvatarUrl } from '@client/helpers/passportAvatar';

import useConstants from './useConstants';

export const usePassportAvatar = (avatarId?: string, size: string = 'islands-retina-middle') => {
    const { config: { avatarHost } } = useConstants();

    return useMemo(() => {
        if (!avatarId) {
            return;
        }

        return getPasssportAvatarUrl({ avatarHost, avatarId, size });
    }, [avatarId, avatarHost, size]);
};
