import { useCallback, useEffect, useMemo, useState } from 'react';
import { useHistory } from 'react-router';

import { toogleHashRoute } from '@client/helpers/history';

import useConstants from './useConstants';
import useMetrika from './useMetrika';

export const useReceiptsConnect = (metrikaGoal: string) => {
    const { fnsData, platform: { isTouch } } = useConstants();
    const metrika = useMetrika();
    const history = useHistory();
    const [url, setUrl] = useState(isTouch ? fnsData?.urls?.touch : undefined);

    useEffect(() => {
        if (url) {
            const urlObject = new URL(url);

            urlObject.searchParams.append('referer', window.location.href);
            urlObject.searchParams.append('ret_path', window.location.origin + '/order-history');
            setUrl(urlObject.href);
        }
    }, []);

    const onConnectClick = useCallback(() => {
        metrika.params({ [metrikaGoal]: true });
        !isTouch && toogleHashRoute(history, '#receipts-popup');
    }, [isTouch, metrika, history, metrikaGoal]);


    return useMemo(() => {
        return { onConnectClick, url };
    }, [onConnectClick, url]);
};
