import axios, { AxiosRequestConfig } from 'axios';
import { useMemo } from 'react';

import useConstants from '@hooks/useConstants';
import { canUseDom } from '@use-platform/react/libs/dom-utils';

export const useRequest = (config?: AxiosRequestConfig) => {
    const { ssrId, baseUrl, authInfo: { user } = {} } = useConstants();
    const { timeout } = config || {};

    return useMemo(
        () =>
            axios.create({
                baseURL: baseUrl + '/api/',
                timeout: timeout || 5000,
                headers: {
                    'x-csrf-token': canUseDom ? window.__CSRF__ : '',
                    'x-visible-uid': user?.uid,
                    'x-ssr-id': ssrId,
                },
            }),
        [baseUrl, ssrId, user?.uid, timeout],
    );
};
