import { useMemo } from 'react';

import useConstants from '@hooks/useConstants';
import { getRoutes } from '@src/routes';
import { IDocumentType } from '@src/types';

const useRoutes = () => {
    const { baseUrl } = useConstants();

    return useMemo(() => {
        const routes = getRoutes(baseUrl);

        return {
            main: () => routes.main,
            order: <P>(currentLocation: Location, props: P) => {
                return {
                    ...currentLocation,
                    state: { path: '/order', props },
                };
            },
            gibdd: () => routes.gibdd,
            gibddSettings: () => routes.gibddSettings,
            gibddSettingsAddDocument: (type: IDocumentType) => {
                if (type === 'DRIVER_LICENSE') {
                    return routes.gibddSettingsDocuments.replace(':id', 'add-dl');
                }

                return routes.gibddSettingsDocuments.replace(':id', 'add-vrc');
            },
            gibddSettingsEditDocument: (id: string) => routes.gibddSettingsDocuments.replace(':id', id),
            penalty: <P>(currentLocation: Location, props: P) => {
                return {
                    ...currentLocation,
                    state: { path: '/penalty', props },
                };
            },
            receipts: () => routes.receipts,
        };
    }, [baseUrl]);
};

export default useRoutes;
