import { i18nServices, ServiceKeyType } from '@client/translations/services';

export const useServiceName = (name?: Nullable<string>, keyName?: Nullable<string>) => {
    const _name = name || '';

    if (!keyName) {
        return _name;
    }

    const tankerName = i18nServices(keyName as ServiceKeyType);

    return tankerName || _name;
};
