// eslint-disable-next-line no-restricted-imports
import i18n, { i18nRaw as i18nRawFactory, I18nOptions } from '@yandex-int/i18n';

interface Keyset<T> {
    ru: T;
    en: T;
}

export default <T>(keyset: Keyset<T>) => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return i18n(keyset as any) as (
        key: keyof T,
        options?: I18nOptions,
    ) => string;
};

export const i18nRaw = <T>(keyset: Keyset<T>) => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return i18nRawFactory(keyset as any) as (
        key: keyof T,
        options?: I18nOptions,
    ) => (string | number | object | undefined)[];
};
