import 'whatwg-fetch';

import { loadableReady } from '@loadable/component';
import cloneDeep from 'lodash/cloneDeep';
import React from 'react';
import ReactDOM from 'react-dom';
import { BrowserRouter as Router } from 'react-router-dom';

import { setI18nLang } from '@yandex-int/i18n';

import Metrika from '@lib/metrika';
import { logErrorInit } from '@src/lib/logError';

import App from './App';

import 'yandex-font/build/browser.css';

if (!window.__FONT_LOADED__) {
    require('yandex-font/build/browser.js');
}

const { authInfo, platform, env } = window.__CONSTANTS__;

logErrorInit(authInfo ? authInfo.user.yu : undefined, platform.isTouch ? 'touch' : 'desktop', env);

const state = cloneDeep(window.__STATE__);
const constants = cloneDeep(window.__CONSTANTS__);
const metrika = new Metrika(window, constants.metrikaId);
const root = document.getElementById('root');

setI18nLang(constants.lang);

try {
    if (window.history.state) {
        window.history.replaceState(undefined, '');
    }
} catch {}

loadableReady(() => {
    window.Ya?.Rum.sendTimeMark('3036');

    return ReactDOM.hydrate(
        React.createElement(
            Router,
            {},
            React.createElement(App, {
                state,
                metrika,
                constants,
                initialSsrErrorMeta: window.__INITIAL_SSR_ERROR_META__,
            }),
        ),
        root,
    );
});
