import * as React from 'react';

import { ErrorsContext, ErrorContextData } from './context';

export const ErrorsContextProvider: React.FC = ({ children }) => {
    const [errors, setErrors] = React.useState<ErrorContextData[]>([]);
    const addError = React.useCallback((data: ErrorContextData) => {
        setErrors((current) => {
            if (!data.group) {
                return [data, ...current];
            }

            return [
                data,
                ...current.filter((item) => {
                    return item.group !== data.group;
                }),
            ];
        });
    }, []);
    const value = React.useMemo(() => {
        return {
            refetch() {
                errors.forEach((error) => {
                    error.refetch();
                });
                setErrors([]);
            },
            addError,
            hasErrors: errors.length > 0,
        };
    }, [errors, addError]);

    return <ErrorsContext.Provider value={value}>{children}</ErrorsContext.Provider>;
};

export function useErrors() {
    return React.useContext(ErrorsContext);
}
