/// <reference lib="dom" />

export default class Metrika {
    private counter?: ANY;
    private firstTime = true;
    private goalTracer: { [_ in string]?: boolean } = {};
    public constructor(private readonly window?: Window, metrikaId?: string | null) {
        if (window && metrikaId) {
            this.window = window;
            this.window.yandex_metrika_callbacks2 = [];

            this.callback(() => {
                try {
                    this.counter = new (window as ANY).Ya.Metrika2({
                        id: metrikaId,
                        clickmap: true,
                        trackLinks: true,
                        accurateTrackBounce: true,
                        webvisor: true,
                    });
                } catch (e) {
                    // empty
                }
            });
            const n = window.document.getElementsByTagName('script')[0];
            const s = window.document.createElement('script');

            s.type = 'text/javascript';
            s.async = true;
            s.src = 'https://mc.yandex.ru/metrika/tag.js';
            n && n.parentNode && n.parentNode.insertBefore(s, n);
        }
    }
    private callback(...fns: Function[]) {
        const { window } = this;

        if (window && Array.isArray(window.yandex_metrika_callbacks2)) {
            window.yandex_metrika_callbacks2.push(...fns);
        }
    }
    private call(method: string, ...args: unknown[]) {
        const fn = () => {
            this.counter[method](...args);
        };

        if (this.counter) {
            fn();
        } else {
            this.callback(fn);
        }
    }
    public hit(url: string, opts?: { referer?: string } & Record<string, string>) {
        if (this.firstTime) {
            this.firstTime = false;
        } else {
            // Beware: Metrika uses 'referer' with one 'r';
            this.call('hit', url, opts);
        }
    }
    public reachGoal(goal: string, params?: object) {
        this.call('reachGoal', goal, params || {});
    }
    public reachGoalOnce(goal: string, params?: object) {
        if (!this.goalTracer[goal]) {
            this.call('reachGoal', goal, params || {});
            this.goalTracer[goal] = true;
        }
    }
    public userParams(params: object) {
        this.call('userParams', params);
    }
    public params(params: object) {
        this.call('params', {
            ohio: params,
        });
    }
}
