import memoize from 'lodash/memoize';

const loadScript = memoize((src: string) => {
    return new Promise<void>((resolve) => {
        const script = document.createElement('script');

        script.id = 'yandex-pay';
        script.src = src;
        script.async = true;
        script.onload = () => resolve();

        document.head.appendChild(script);

        const style = document.createElement('style');

        style.setAttribute('type', 'text/css');
        // На штрафах мы не показываем персонализированную кнопку
        // Поэтому кнопку можно и нужно немного сжать
        style.textContent = 'html .ya-pay-button{min-width:230px};';

        document.head.appendChild(style);
    });
});

export const loadYandexPayScript = (src: string, onLoad: () => void) => {
    loadScript(src).then(onLoad);
};
