import * as redux from 'redux';

import type { State } from '@src/types';

import { BillsAction, billsReducer } from './bills';
import { OrderAction, ordersReducer } from './orders';

export type Action = OrderAction | BillsAction;

const devTools =
    (typeof window !== 'undefined' &&
        process.env.NODE_ENV !== 'production' &&
        window.__REDUX_DEVTOOLS_EXTENSION__?.()) ||
    ((f: unknown) => f);

export const createStore = (state: State) =>
    redux.createStore(
        redux.combineReducers(
            { orders: ordersReducer, bills: billsReducer }),
        state,
        devTools,
    );
