import { Reducer } from 'redux';

import { IOrderList, OrdersState } from '@src/types';

export type OrderAction =
    { type: 'SET_OFFLINE'; isOffline?: boolean; } |
    { type: 'CHANGE_ALIAS'; payload?: string; } |
    { type: 'UPDATE_ORDERS_START'; } |
    { type: 'FETCH_FAILED'; } |
    { type: 'CHANGE_ALIAS'; payload?: string; } |
    { type: 'UPDATE_ORDERS'; payload?: IOrderList; } |
    { type: 'SET_FAMILY_FILTER'; payload?: string; } |
    { type: 'FETCH_MORE'; payload: IOrderList; };

const DEFAULT_STATE: OrdersState = {};

export const ordersReducer: Reducer<OrdersState, OrderAction> = (state, action) => {
    switch (action.type) {
        case 'SET_OFFLINE': {
            return {
                ...state,
                isOffline: action.isOffline,
            };
        }
        case 'CHANGE_ALIAS': {
            return {
                ...state,
                orders: undefined,
                firstLoading: true,
                alias: action.payload,
                familyFilter: action.payload !== 'plus' ? state?.familyFilter : undefined,
            };
        }
        case 'UPDATE_ORDERS_START': {
            return {
                ...state,
                isUpdating: true,
                isUpdateFailed: false,
            };
        }
        case 'UPDATE_ORDERS': {
            return {
                ...state,
                isUpdating: false,
                isUpdateFailed: false,
                firstLoading: false,
                orders: action.payload,
            };
        }
        case 'FETCH_MORE': {
            return {
                ...state,
                isUpdating: false,
                isUpdateFailed: false,
                orders: {
                    pageInfo: action.payload.pageInfo,
                    edges: [...(state?.orders?.edges || []), ...action.payload.edges],
                },
            };
        }

        case 'FETCH_FAILED': {
            return {
                ...state,
                isUpdating: false,
                isUpdateFailed: true,
            };
        }

        case 'SET_FAMILY_FILTER': {
            return {
                ...state,
                orders: undefined,
                alias: state?.alias !== 'plus' ? state?.alias : undefined,
                familyFilter: action.payload,
            };
        }

        default:
            return state || DEFAULT_STATE;
    }
};

export const setFamilyFilter = (uid?: string) => ({ type: 'SET_FAMILY_FILTER', payload: uid } as OrderAction);
