import React from 'react';

import Button from '@components/Button';
import Transition from '@components/Transition';

import styles from './index.module.css';

export type Props = {
    in?: boolean;
    text: React.ReactNode;
    actionText: React.ReactNode;
    onAction?: null | (() => void);
};

const ErrorMessage = ({ in: _in, onAction, ...rest }: Props) => {
    const [text, setText] = React.useState(rest.text);
    const [actionText, setActionText] = React.useState(rest.actionText);
    const prevIn = React.useRef(_in);

    React.useEffect(() => {
        if (prevIn.current !== _in && _in) {
            setText(rest.text);
            setActionText(rest.actionText);
        }

        prevIn.current = _in;
    }, [_in, rest.text, rest.actionText]);

    return (
        <Transition in={_in} type="custom" activeClassName={styles.alert_visible} className={styles.alert}>
            <div className={styles.content}>
                <div className={styles.text}>{text}</div>
                {onAction && (
                    <div className={styles.action}>
                        <Button view="action" size="m" onClick={onAction}>
                            {actionText}
                        </Button>
                    </div>
                )}
            </div>
        </Transition>
    );
};

export default ErrorMessage;
