import i18nFactory from '@i18n';
import * as keyset from '@i18n/Lazy.i18n';
import React, { useEffect, useRef } from 'react';

import { i18nCommon } from '@client/translations/common';
import { useSelector } from '@hooks/redux';
import { useErrors } from '@lib/errors';

import ErrorMessage from './ErrorMessage';

const i18n = i18nFactory(keyset);

const ErrorToastScreen: React.FC = () => {
    const { hasErrors, refetch } = useErrors();
    const isOffline = useSelector((state) => state.orders.isOffline);
    const currentOffline = useRef(isOffline);

    useEffect(() => {
        if (!isOffline && isOffline !== currentOffline.current && hasErrors) {
            refetch();
        }

        currentOffline.current = isOffline;
    }, [isOffline, hasErrors, refetch]);

    return (
        <ErrorMessage
            in={hasErrors}
            text={
                currentOffline.current ? (
                    <>
                        {i18n('Не удалось подключиться.')}
                        <br />
                        {i18n('Проверьте соединение.')}
                    </>
                ) : (
                    <>
                        {i18n('Не удалось получить данные с сервера.')}
                        <br />
                        {i18n('Повторите попытку.')}
                    </>
                )
            }
            onAction={refetch}
            actionText={i18nCommon('repeat')}
        />
    );
};

export default ErrorToastScreen;
