import React from 'react';

import { cn } from '@bem-react/classname';

import { IBill } from '@src/types';

import { BillPaymentYaPay } from '../../Payment/YandexPay';

import './index.css';

interface Props {
    bill: IBill;
}

const cnPenaltyFooter = cn('PenaltyFooter');

const PenaltyDetailsFooter: React.FC<Props> = ({ bill }) => {
    return (
        <div className={cnPenaltyFooter()}>
            <BillPaymentYaPay bills={[bill]} />
        </div>
    );
};

export default PenaltyDetailsFooter;
