import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React from 'react';

import { cn } from '@bem-react/classname';

import Icon from '@components/Icon';
import Image from '@components/Image';

import './index.css';

interface Props {
    splashUrl?: string;
    iconUrl?: string;
    number?: string;
    amount?: string;
    due?: string;
    negative?: boolean;
}

const cnPenaltyHeader = cn('PenaltyHeader');

const i18n = i18nFactory(keyset);

const PenaltyDetailsHeader: React.FC<Props> = ({ splashUrl, iconUrl, number, amount, due, negative }) => {
    return (
        <div className={cnPenaltyHeader({ long: Boolean(due) || negative })}>
            {splashUrl ? <Image cover src={splashUrl} className={cnPenaltyHeader('splash')} /> : null}
            {negative ? <div className={cnPenaltyHeader('negative')}> </div> : null}
            <div className={cnPenaltyHeader('content')}>
                {iconUrl ? <Image cover src={iconUrl} className={cnPenaltyHeader('icon')} /> : null}
                <h1 className={cnPenaltyHeader('name')}>{i18n('Штраф ГИБДД')}</h1>
                {number ? <span className={cnPenaltyHeader('number')}>№ {number}</span> : null}
                {amount ? <span className={cnPenaltyHeader('amount')}>{amount}</span> : null}
                <div className={cnPenaltyHeader('status')}>
                    {negative ?
                        <><Icon name="error" /><span className={cnPenaltyHeader('status-text')}>{i18n('Просрочен')}</span></> :
                        <><Icon name="due" /><span className={cnPenaltyHeader('status-text')}>{i18n('До')} {due}</span></>}
                </div>
            </div>
        </div>
    );
};

export default PenaltyDetailsHeader;
