import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React, { useCallback, useState } from 'react';

import { cn } from '@bem-react/classname';

import Icon from '@components/Icon';

import './index.css';

const cnExpand = cn('NegativeAbout');

const i18n = i18nFactory(keyset);

const PenaltyNegativeAbout: React.FC = () => {
    const [expanded, setExpanded] = useState(false);

    const onClick = useCallback(() => setExpanded(!expanded), [expanded, setExpanded]);

    return (
        <div className={cnExpand('container')}>
            <div className={cnExpand('panel')} onClick={onClick}>
                <Icon className={cnExpand('icon')} name="error" />
                <span className={cnExpand('title')}>{i18n('Чем грозит просрочка платежей?')}</span>
                <Icon className={cnExpand('icon')} name="expand" />
            </div>
            {expanded &&
                <div className={cnExpand('expanded')}>
                    <span className={cnExpand('first-line')}>
                        {i18n('Штраф, не оплаченный в течение 70 дней с момента выставления, может быть передан судебным приставам.')}
                    </span>
                    <span className={cnExpand('second-line')}>
                        {i18n('В результате возможен новый штраф в двукратном размере, ограничение выезда за границу, конфискация имущества, и другие санкции.')}
                    </span>
                </div>
            }
        </div>
    );
};

export default PenaltyNegativeAbout;
