import React from 'react';
import { useHistory, useLocation } from 'react-router';

import DetailPage from '@components/DetailPage';
import useRoutes from '@hooks/useRoutes';

import PenaltyDetails from './PenaltyDetails';

const PenaltyDetailsRoute: React.FC = () => {
    const routes = useRoutes();
    const history = useHistory();
    const { state } = useLocation();

    const handleClose = React.useCallback(() => {
        const { state, ...to } = history.location;

        history.replace(to);
    }, [history]);

    if (!state || !state.props) {
        history.replace(routes.gibdd());

        return null;
    }

    return (
        <DetailPage onClose={handleClose}>
            <PenaltyDetails {...state.props} />
        </DetailPage>
    );
};

export default PenaltyDetailsRoute;
