import React, { useMemo } from 'react';

import Page from '@components/Page';
import { useSelector } from '@hooks/redux';

import GibddScreenList from './List';
import { GibddScreenLoader } from './Loader';
import { GibddScreenOnboarding } from './Onboarding';
import { BillsPayment } from './Payment';

export type GibbdScreenProps = {
    exceeded?: boolean;
}

export const GibddScreen: React.FC<GibbdScreenProps> = ({ exceeded }) => {
    const documents = useSelector((state) => state.bills.documents);
    const { state, list } = useSelector((state) => state.bills.bills);

    const showOnboarding = useMemo(
        () => state === 'unregistered' || (documents.state === 'stable' && documents.list.length === 0),
        [state, documents.state, documents.list],
    );

    const content = useMemo(
        () => {
            if (showOnboarding) {
                return <GibddScreenOnboarding />;
            }

            if (state === 'emulation' || state === 'outdated') {
                return <GibddScreenLoader type="simple" />;
            }

            if (state === 'syncing') {
                return <GibddScreenLoader type={exceeded ? 'overloaded' : 'default'} />;
            }

            if (state === 'completed') {
                return <GibddScreenList documents={documents.list} bills={list} />;
            }

            return null;
        },
        [state, list, showOnboarding, documents.list, exceeded],
    );

    return (
        <Page>
            {content}
            <BillsPayment />
        </Page>
    );
};
