import React from 'react';
import { Route, Switch } from 'react-router';

import { useBillsPolling } from '@hooks/useBillsPolling';
import useRoutes from '@hooks/useRoutes';

import { GibddScreen } from './GibddScreen';

import { GibddScreenSettings } from '../GibddScreenSettings';
import DocumentFormRoute from '../GibddScreenSettings/Form/DocumentFormRoute';

export const GibddScreenRoute: React.FC = () => {
    const { exceeded } = useBillsPolling();

    const routes = useRoutes();

    return (
        <Switch>
            <Route path={routes.gibddSettingsAddDocument('DRIVER_LICENSE')}>
                <DocumentFormRoute type="DRIVER_LICENSE" />
            </Route>
            <Route path={routes.gibddSettingsAddDocument('VEHICLE_REGISTRATION_CERTIFICATE')}>
                <DocumentFormRoute type="VEHICLE_REGISTRATION_CERTIFICATE" />
            </Route>
            <Route path={routes.gibddSettingsEditDocument(':id')}>
                <DocumentFormRoute />
            </Route>
            <Route path={routes.gibddSettings()}>
                <GibddScreenSettings />
            </Route>
            <Route path={routes.gibdd()}>
                <GibddScreen exceeded={exceeded} />
            </Route>
        </Switch>
    );
};
