import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React, { useMemo } from 'react';
import { Link } from 'react-router-dom';

import { cn } from '@bem-react/classname';

import { getNormalizedDocName } from '@client/screens/GibddScreenSettings/GibddScreenSettings.utils';
import Image from '@components/Image';
import useRoutes from '@hooks/useRoutes';
import { IDocumentType } from '@src/types';

import HalfSvg from './assets/half.svg';
import MoveToSvg from './assets/moveTo.svg';

import './Banner.css';

export type GibddScreenListBannerProps = {
    type: IDocumentType;
    marginType?: 'short' | 'long';
}

const cnGibddScreenListBanner = cn('GibddScreenListBanner');

const i18n = i18nFactory(keyset);

export const GibddScreenListBanner: React.FC<GibddScreenListBannerProps> = ({ type, marginType = 'short' }) => {
    const routes = useRoutes();
    const reverseType = useMemo<IDocumentType>(
        () => type === 'DRIVER_LICENSE' ? 'VEHICLE_REGISTRATION_CERTIFICATE' : 'DRIVER_LICENSE',
        [type],
    );

    return (
        <Link className={cnGibddScreenListBanner('', { [marginType]: true })} to={routes.gibddSettingsAddDocument(reverseType)}>
            <Image className={cnGibddScreenListBanner('Half')} src={HalfSvg} />
            <div className={cnGibddScreenListBanner('MessageBox')}>
                <h3 className={cnGibddScreenListBanner('Header')}>{i18n('Вы добавили')} {getNormalizedDocName(type)}</h3>
                <span className={cnGibddScreenListBanner('Description')}>
                    {i18n('Добавьте также')}{' '}
                    {getNormalizedDocName(reverseType)},{' '}
                    {i18n('чтобы вовремя оплачивать штрафы')}
                </span>
            </div>
            <Image className={cnGibddScreenListBanner('MoveTo')} src={MoveToSvg} />
        </Link>
    );
};
