import qs from 'query-string';

export type QueryParams = {
    shortVariant: string;
};

export const getQueryParams = (search?: string): QueryParams => {
    const allQueryParams = !search ? {} : qs.parse(search);
    const shortVariant = typeof allQueryParams.shortVariant === 'string' ? allQueryParams.shortVariant : '0';

    return {
        shortVariant,
    };
};
