import i18nFactory from '@i18n';
import * as keyset from '@i18n/Gibdd.i18n';
import React, { useCallback, useState } from 'react';
import { Link } from 'react-router-dom';

import Icon from '@components/Icon';
import IconButton from '@components/IconButton';
import Image from '@components/Image';
import { useBillsRestartSearch } from '@hooks/useBillsRestartSearch';
import useConstants from '@hooks/useConstants';
import useMetrika from '@hooks/useMetrika';
import useRoutes from '@hooks/useRoutes';

import RepeatSvg from './assets/repeat.svg';
import styles from './index.module.css';

export type GibddScreenHeaderProps = {
    header: string;
    hideHeader?: boolean;
}

const i18n = i18nFactory(keyset);

const GibddScreenListHeader: React.FC<GibddScreenHeaderProps> =
    ({ header, hideHeader = false }: GibddScreenHeaderProps) => {
        const metrika = useMetrika();
        const routes = useRoutes();
        const { flags: { billsOnly } } = useConstants();

        const [restartBlocked, setRestartBlocked] = useState(false);
        const restartSearchFn = useBillsRestartSearch();

        const restartSearch = useCallback(
            () => {
                setRestartBlocked(true);
                if (!restartBlocked) {
                    metrika.reachGoal('click_search_fines', {});
                    restartSearchFn();
                }
            },
            [metrika, restartBlocked, setRestartBlocked, restartSearchFn],
        );

        return (
            <>
                {!billsOnly &&
                    <div className={styles.controls}>
                        <Link to={routes.main}>
                            <IconButton type="filled">
                                <Icon size="s" name="arrowleft" />
                            </IconButton>
                        </Link>
                        <Link to={routes.gibddSettings}>
                            <IconButton>
                                <Icon size="s" name="settings" />
                            </IconButton>
                        </Link>
                    </div>
                }
                {!hideHeader &&
                    <div className={styles['header-block']}>
                        <div className={styles['header-line']}>
                            <h1 className={styles.header}>{header}</h1>
                            {billsOnly &&
                                <Link to={routes.gibddSettings}>
                                    <IconButton size="m">
                                        <Icon size="xs" name="settings" />
                                    </IconButton>
                                </Link>
                            }
                        </div>
                        <div onClick={restartSearch} className={styles.repeater}>
                            <Image className={styles['repeat-icon']} src={RepeatSvg} />
                            <span className={styles['repeat-text']}>{i18n('Искать снова')}</span>
                        </div>
                    </div>
                }
            </>
        );
    };

export default GibddScreenListHeader;
